/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.LunarForecast;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;

public class LunarForecastCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"lunarForecast").executes(cs -> LunarForecastCommand.setLunarEvent((CommandSourceStack)cs.getSource()))).then(Commands.m_82127_((String)"recompute").executes(cs -> LunarForecastCommand.recompute((CommandSourceStack)cs.getSource())));
    }

    public static int recompute(CommandSourceStack source) {
        ServerLevel world = source.m_81372_();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.m_81352_((Component)new TranslatableComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        lunarForecast.getForecast().clear();
        lunarForecast.setLastCheckedGameTime(Long.MIN_VALUE);
        lunarContext.computeLunarForecast(world, lunarForecast, world.m_46467_());
        LunarEventSavedData.get((LevelAccessor)world).setForecast(lunarContext.getLunarForecast());
        source.m_81354_((Component)new TranslatableComponent("enhancedcelestials.lunarforecast.recompute"), true);
        return 1;
    }

    public static int setLunarEvent(CommandSourceStack source) {
        ServerLevel world = source.m_81372_();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.m_81352_((Component)new TranslatableComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        long dayLength = lunarContext.getLunarTimeSettings().getDayLength();
        long currentDay = world.m_46468_() / dayLength;
        TranslatableComponent textComponent = null;
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        for (int i = Math.min(100, lunarForecast.getForecast().size() - 1); i > 0; --i) {
            LunarEventInstance lunarEventInstance = lunarForecast.getForecast().get(i);
            LunarEvent event = lunarEventInstance.getEvent(lunarContext.getLunarEvents());
            CustomTranslationTextComponent name = event.getTextComponents().getName();
            if (textComponent == null) {
                textComponent = new TranslatableComponent(name.m_131328_());
            } else {
                textComponent.m_130946_(", ").m_7220_((Component)new TranslatableComponent(name.m_131328_()));
            }
            textComponent.m_7220_((Component)new TranslatableComponent("enhancedcelestials.lunarforecast.days_left", new Object[]{lunarEventInstance.getDaysUntil(currentDay)}));
        }
        if (textComponent != null) {
            source.m_81354_((Component)new TranslatableComponent("enhancedcelestials.lunarforecast.header", new Object[]{textComponent.m_130946_(".")}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("enhancedcelestials.lunarforecast.empty", new Object[]{textComponent}).m_130940_(ChatFormatting.YELLOW), true);
        }
        return 1;
    }
}

